<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
/**
 * Description of category-class
 *
 * @author Admin
 */
class Pf_Portfolio {
//put your code here
    public $db;
    function __construct() {
        $this->db =   Pf::database();
    }
     /* Portfolio functions */
    public function list_portfolio($clause='', $array_clause='', $col='*') {
        $this->db->select($col,'pf_portfolios',$clause, $array_clause);
        return $this->db->fetch_assoc_all();
    }
    public function delete_portfolio($portid) {
        if(!empty($portid)){
            $this->db->delete('pf_portfolios',"`portfolio_id`=?",array($portid));
            $this->delete_meta($portid);
        }
    }
    public function portfolio_action($id,$action) {
        switch ($action) {
            case 'publish':
               $this->db->update('pf_portfolios',array("portfolio_status"=>1), "`portfolio_id`=?",array($id));
                break;
            case 'unpublish':
               $this->db->update('pf_portfolios',array("portfolio_status"=>2), "`portfolio_id`=?",array($id));
                break;
            case 'delete':
                $this->delete_portfolio($id);
                break;
        }
        
    }
    
    /* Categories functions */
    public function list_cat($clause,$array_clause, $col='*') {
        $this->db->select($col,'pf_portfolio_categories',$clause,$array_clause);
        $list   =   $this->db->fetch_assoc_all();
        $array_list = array();
        if(!empty($list)){
            foreach($list as $row){
                $array_list[$row['category_id']] = $row;
            }
        }
        return $array_list;
    }
    public function list_cat_name() {
        $list   =   $this->list_cat('',array(),'category_id,category_name');
        if(!empty($list)){
        foreach ($list as $cat)
        {
            $list_name[$cat['category_id']]= $cat['category_name'];
        }
        return $list_name;}
        else return array();
    }
    public function delete_category($id) {
        $this->db->delete('pf_portfolio_categories',"`category_id`=?", array($id));
        $list   =   $this->list_portfolio("`portfolio_category`=?", array($id));
        foreach($list as $item){
            $this->delete_portfolio($item['portfolio_id']);
        }
    }
    public function category_action($id,$action) {
        switch ($action) {
            case 'publish':
               $this->db->update('pf_portfolio_categories',array("category_status"=>1), "`category_id`=?",array($id));
                break;
            case 'unpublish':
               $this->db->update('pf_portfolio_categories',array("category_status"=>2), "`category_id`=?",array($id));
                break;
            case 'delete':
                 $this->delete_category($id);
                break;
        }
    }
    
    //meta
    public function get_meta($portid) {
        if(!empty($portid)){
            $this->db->select('meta_name,meta_value','pf_portfolio_meta',"`meta_portfolio`  = ?", array($portid));
        }
        return $this->db->fetch_assoc_all();
    }
    public function delete_meta($portid){
        $this->db->delete('pf_portfolio_meta',"`meta_portfolio`=?",array($portid));
    }
    
    
    public function filter_public($array) {
        $result =   array();
        for ($i = 0; $i < count($array); $i++) {
            if (!empty($array[$i]) && $array[$i]['portfolio_status'] == 1) {
                $result[] = $array[$i];
            }
        }
        return $result;
    }
    public function filter_cat($array, $main){
        for($i=0; $i<count($array); $i++){
            $id =   $array[$i]['portfolio_category'];
            $s   =   false;
            foreach($main as $cat){
                if($cat['category_id']==$id)
                    $s  =   true;
            }
            if($s   ==  false) unset($array[$i]);
        }
        return $array;
    }
}